<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:ao="http://www.aortarelease.nl/805/"
                xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
                version="1.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
            <xsl:variable name="p_1" select="1+    count(preceding-sibling::*[name()=name(current())])"/>
            <xsl:if test="$p_1&gt;1 or following-sibling::*[name()=name(current())]">[<xsl:value-of select="$p_1"/>]</xsl:if>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>']</xsl:text>
            <xsl:variable name="p_2"
                          select="1+   count(preceding-sibling::*[local-name()=local-name(current())])"/>
            <xsl:if test="$p_2&gt;1 or following-sibling::*[local-name()=local-name(current())]">[<xsl:value-of select="$p_2"/>]</xsl:if>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <xsl:apply-templates select="/" mode="M6"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


<!--PATTERN AuthenticationToken-->


	<!--RULE -->
<xsl:template match="/soap:Envelope[1]/soap:Header/*" priority="1001" mode="M6">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@soap:actor='http://www.aortarelease.nl/actor/gbx' or @soap:actor='http://www.aortarelease.nl/actor/zim'"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="name()"/>
               <xsl:text/>/@soap:actor='<xsl:text/>
               <xsl:value-of select="@soap:actor"/>
               <xsl:text/>' MOET een zijn van 'http://www.aortarelease.nl/actor/gbx', 'http://www.aortarelease.nl/actor/zim' (@soap:actor='http://www.aortarelease.nl/actor/gbx' or @soap:actor='http://www.aortarelease.nl/actor/zim' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="/soap:Envelope[1]/soap:Header[1]/ao:authenticationTokens[1]/ao:signedData[1]"
                 priority="1000"
                 mode="M6">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="ao:authenticationData/ao:messageId/ao:root =//hl7:interactionId/../hl7:id/@root"/>
         <xsl:otherwise>
            <xsl:message>Root in messageId moet gelijk zijn aan message.id root (ao:authenticationData/ao:messageId/ao:root =//hl7:interactionId/../hl7:id/@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="ao:authenticationData/ao:messageId/ao:extension = //hl7:interactionId/../hl7:id/@extension"/>
         <xsl:otherwise>
            <xsl:message>Extension in messageId moet gelijk zijn aan message.id root (ao:authenticationData/ao:messageId/ao:extension = //hl7:interactionId/../hl7:id/@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="ao:authenticationData/ao:notBefore &lt; ao:authenticationData/ao:notAfter "/>
         <xsl:otherwise>
            <xsl:message>Datum notBefore moet voor notAfter liggen (ao:authenticationData/ao:notBefore &lt; ao:authenticationData/ao:notAfter / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="ao:authenticationData/ao:addressedParty/ao:root = '2.16.840.1.113883.2.4.6.6'"/>
         <xsl:otherwise>
            <xsl:message>Root in addressedParty moet '2.16.840.1.113883.2.4.6.6' zijn (ao:authenticationData/ao:addressedParty/ao:root = '2.16.840.1.113883.2.4.6.6' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="ao:authenticationData/ao:addressedParty/ao:extension = '1'"/>
         <xsl:otherwise>
            <xsl:message>Extension in addressedParty moet '1' zijn (ao:authenticationData/ao:addressedParty/ao:extension = '1' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="ao:coSignedData/ao:triggerEventId"/>
      <xsl:variable name="interactionId" select="//hl7:interactionId[1]/@extension"/>
      <xsl:variable name="vocabFile"
                    select="concat('../vocab/',//hl7:interactionId[1]/@root,'.xml')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference[@extension=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>coSignedData/triggerEventId '<xsl:text/>
               <xsl:value-of select="$codeValue"/>
               <xsl:text/>' (Trigger Event) moet 
                '<xsl:text/>
               <xsl:value-of select="document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>
               <xsl:text/>' zijn  (document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference[@extension=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(ao:coSignedData/ao:patientId/ao:extension != //node()[@root='2.16.840.1.113883.2.4.6.3']/@extension) "/>
         <xsl:otherwise>
            <xsl:message>BSN in token moet overeenkomen met BSN in payload (not(ao:coSignedData/ao:patientId/ao:extension != //node()[@root='2.16.840.1.113883.2.4.6.3']/@extension) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="((ao:coSignedData/ao:patientId/ao:root = '2.16.840.1.113883.2.4.6.3')  or not(//node()[@root='2.16.840.1.113883.2.4.6.3']/@extension))"/>
         <xsl:otherwise>
            <xsl:message>Token moet het burgerservicenummer bevatten (((ao:coSignedData/ao:patientId/ao:root = '2.16.840.1.113883.2.4.6.3') or not(//node()[@root='2.16.840.1.113883.2.4.6.3']/@extension)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M6"/>
   <xsl:template match="@*|node()" priority="-2" mode="M6">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>
</xsl:stylesheet>